import { StarXpandCommand } from "star-io10-web";

export class LabelSample04_For203dpi_ShippingLabel1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleLineSpace(0.0)
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 21.0),
              new StarXpandCommand.PageModeBuilder()
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(50.0, 8.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(4.0)
                    .actionPrintText("${business_name}\n"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(42.0, 8.0)
                    .setX(6.0)
                    .setY(10.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleLineSpace(0.0)
                    .actionPrintText("${address}\n"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(42.0, 4.0)
                    .setX(6.0)
                    .setY(17.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${telephone_number}\n",
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "logo_01.png",
                    47.0,
                    0.0,
                    200,
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "shipping_label_house.png",
                    0.0,
                    10.0,
                    40,
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "shipping_label_phones_old.png",
                    0.0,
                    16.0,
                    40,
                  ),
                ),
            )
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 30.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    72.0,
                    30.0,
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 3.0)
                    .setX(1.0)
                    .setY(1.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleBold(true)
                    .actionPrintText("TO:"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(70.0, 28.0)
                    .setX(2.0)
                    .setY(4.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleLineSpace(3.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(4.0)
                    .actionPrintText("${name_to}\n")
                    .styleVerticalPositionBy(4.0)
                    .actionPrintText("${address_to}\n"),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "business_name" : "BUSINESS NAME",
    "address" : "1234 MAIN AVENUE LONDON,\\nSW1A 1AA",
    "telephone_number" : "(111) 222 333",
    "name_to" : "John Smith",
    "address_to" : "123 HIGH STREET LONDON,\\n\\nSW1A 1AA"
}`,
    );
  }
}
